/* ** The following functions are defined on this page **

-- general utils
function Disallow(form)
function validateEmail( email ) 

-- string utilities
function stringToArray(theString)
function reverseString(theString)
function RemoveNonPrintingChars(theString) 

-- cookie utils
function GetCookieOld (name) 
function GetOligoCookie (theSeq) 
function GetEmailCookie (email) 
function SaveOligoCookie (theSeq) 
function SaveEmailCookie (email) 
function GetCookie (name) 
function setCookie( name, value, expires, path, domain, secure )
function deleteCookie( name, path, domain ) 
function getCookieVal (offset) 
function GetDefCookie (name, defaultval)
function GetDelimitedValue(theString, offset, delimiter)


**  ***/

function Disallow(form) {
	form.oligoBox.focus();
}

function validateEmail( email ) {
	if ( email.length >= 8 && email.indexOf("@") >= 2) {
		return true;
	}
	return false
}

function stringToArray(theString)
{	
	theArray=new Array(theString.length);
	for( var i=0; i<theString.length; i++) 
		theArray[i]=theString.charAt(i); 
	return theArray;
}

function reverseString(theString)
{	
	var reversedString="";
	for( var i=theString.length-1; i>=0; i--) 
		reversedString+=theString.charAt(i);
	return reversedString;
}

function RemoveNonPrintingChars(theString) 
{
	var returnString = ""
	for ( var i = 0; i < theString.length; i++) {
		if ( theString.charAt(i) > " ") {
			returnString += theString.charAt(i);
		}
	}
	return returnString
}

// cookie utilities

//  Function to return the value of the cookie specified by "name".
//    name - String object containing the cookie name.
//    returns - String object containing the cookie value, or null if
//      the cookie does not exist.



function GetCookieOld (name) {
  var arg = name + "=";
  var alen = arg.length;
  var clen = document.cookie.length;
  var i = 0;
  while (i < clen) {
    var j = i + alen;
    if (document.cookie.substring(i, j) == arg)
      return getCookieVal (j);
    i = document.cookie.indexOf(" ", i) + 1;
    if (i == 0) break;
  }
  return null;
}

function GetOligoCookie (seq) {
	return GetDefCookie ("oligoSeq", seq);
}

function GetEmailCookie (email) {
	return GetDefCookie("emailAddress", email);
}

function SaveOligoCookie (seq) {
	setCookie("oligoSeq", seq, 30);
	setCookie("oligoSeq", seq, 30,"/");
	setCookie("oligoSeq", seq, 30,"/","basic.northwestern.edu");
	setCookie("oligoSeq", seq, 30,"/","bioinformatics.northwestern.edu");
}

function SaveEmailCookie (email) {
	setCookie("emailAddress", email, 30);
	setCookie("emailAddress", email, 30,"/");
	setCookie("emailAddress", email, 30,"/","basic.northwestern.edu");
	setCookie("emailAddress", email, 30,"/","bioinformatics.northwestern.edu");
}

// classic cookie functions
function getCookie( name ) {
	var start = document.cookie.indexOf( name + "=" );
	var len = start + name.length + 1;
	if ( ( !start ) && ( name != document.cookie.substring( 0, name.length ) ) ) {
		return null;
	}
	if ( start == -1 ) return null;
	var end = document.cookie.indexOf( ';', len );
	if ( end == -1 ) end = document.cookie.length;
	return unescape( document.cookie.substring( len, end ) );
}

function setCookie( name, value, expires, path, domain, secure ) {
	var today = new Date();
	today.setTime( today.getTime() );
	if ( expires ) {
		expires = expires * 1000 * 60 * 60 * 24;
	}
	var expires_date = new Date( today.getTime() + (expires) );
	document.cookie = name+'='+escape( value ) +
		( ( expires ) ? ';expires='+expires_date.toGMTString() : '' ) + //expires.toGMTString()
		( ( path ) ? ';path=' + path : '' ) +
		( ( domain ) ? ';domain=' + domain : '' ) +
		( ( secure ) ? ';secure' : '' );
}

function deleteCookie( name, path, domain ) {
	if ( getCookie( name ) ) document.cookie = name + '=' +
			( ( path ) ? ';path=' + path : '') +
			( ( domain ) ? ';domain=' + domain : '' ) +
			';expires=Thu, 01-Jan-1970 00:00:01 GMT';
}

// end of classic cookie functions

function getCookieVal (offset) {
  var endstr = document.cookie.indexOf (";", offset);
  if (endstr == -1) {
    endstr = document.cookie.length;
  }
  return unescape(document.cookie.substring(offset, endstr));
}


// Function to get a cookie value. if it does not exist, then pass default

function GetDefCookie (name, defaultval) {
	var value = getCookie(name);
	if (value == null) {
		return defaultval;
	}
	return value;
}

function GetDelimitedValue(theString, offset, delimiter) {
  var endstr = theString.indexOf (delimiter, offset);
  if (endstr == -1)
    endstr = theString.length;
  if (endstr-offset<1) return "";
  return theString.substring(offset, endstr);
}
